Ext.define('Override.app.TapHold', {
    override: 'Ext.dataview.DataView',
    doInitialize: function() {

        var me = this,
            triggerObj = {
                delegate: '> div',
                scope: me
            },
            clearObj = {
                scope: me
            },
            elementContainerElement;


        me.getViewItems();
        elementContainerElement = me.elementContainer.element;

        clearObj[me.getTriggerCtEvent()] = 'onContainerTrigger';
        me.element.on(clearObj);

        triggerObj[me.getTriggerEvent()] = 'onItemTrigger';
        elementContainerElement.on(triggerObj);

        elementContainerElement.on({
            delegate: '> div',
            scope   : me,

            touchstart: 'onItemTouchStart',
            touchend  : 'onItemTouchEnd',
            tap       : 'onItemTap',
            taphold   : 'onItemTapHold',
            touchmove : 'onItemTouchMove',
            doubletap : 'onItemDoubleTap',
            swipe     : 'onItemSwipe'
        });
    },

    onItemTapHold: function(e) {
        var me = this,
            target = e.getTarget(),
            index = me.getViewItems().indexOf(target),
            item = Ext.get(target);

        me.fireEvent('itemtaphold', me, index, item, e);
    }
});